import { R as ResolvableHead, r as CreateClientHeadOptions, U as Unhead, I as RenderDomHeadOptions } from './shared/unhead.Prz0gZXE.js';
import 'hookable';

declare function createHead<T = ResolvableHead>(options?: CreateClientHeadOptions): Unhead<T>;

/**
 * Render the head tags to the DOM.
 */
declare function renderDOMHead<T extends Unhead<any>>(head: T, options?: RenderDomHeadOptions): Promise<void>;

declare function createDebouncedFn(callee: () => void, delayer: (fn: () => void) => void): () => void;

export { CreateClientHeadOptions, Unhead, createDebouncedFn, createHead, renderDOMHead };
