declare module 'vue-router/auto-routes' {
  import type { RouteRecordRaw, Router } from 'vue-router'

  /**
   * Array of routes generated by unplugin-vue-router
   */
  export const routes: readonly RouteRecordRaw[]

  /**
   * Setups hot module replacement for routes.
   *
   * @param router - The router instance
   * @param hotUpdateCallback - Callback to be called after replacing the routes and before the navigation
   *
   * @example
   *
   * ```ts
   * import { createRouter, createWebHistory } from 'vue-router'
   * import { routes, handleHotUpdate } from 'vue-router/auto-routes'
   * const router = createRouter({
   *   history: createWebHistory(),
   *   routes,
   * })
   * if (import.meta.hot) {
   *   handleHotUpdate(router)
   * }
   * ```
   */
  export function handleHotUpdate(
    router: Router,
    hotUpdateCallback?: (newRoutes: RouteRecordRaw[]) => void
  ): void
}

declare module 'vue-router' {
  import type { RouteNamedMap } from 'vue-router/auto-routes'
  import type { ParamParserCustom } from 'vue-router/auto-resolver'

  export interface TypesConfig {
    RouteNamedMap: RouteNamedMap
    ParamParsers: ParamParserCustom
  }
}

// Make the macros globally available
declare global {
  const definePage: (typeof import('unplugin-vue-router/runtime'))['definePage']
}

export {}
