"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateTemplate = generateTemplate;
const codeFeatures_1 = require("../codeFeatures");
const names = require("../names");
const utils_1 = require("../utils");
const merge_1 = require("../utils/merge");
const src_1 = require("./src");
function* generateTemplate(options, ctx, selfType) {
    yield* generateSetupExposed(options, ctx);
    yield* generateTemplateCtx(options, ctx, selfType);
    yield* generateTemplateComponents(options);
    yield* generateTemplateDirectives(options);
    if (options.styleCodegen) {
        yield* options.styleCodegen.codes;
    }
    if (options.templateCodegen) {
        yield* options.templateCodegen.codes;
    }
}
function* generateTemplateCtx({ vueCompilerOptions, script, styleCodegen, scriptSetupRanges, fileName }, ctx, selfType) {
    const exps = [];
    const emitTypes = [];
    const propTypes = [];
    if (vueCompilerOptions.petiteVueExtensions.some(ext => fileName.endsWith(ext))) {
        exps.push([`globalThis`]);
    }
    if (selfType) {
        exps.push([`{} as InstanceType<__VLS_PickNotAny<typeof ${selfType}, new () => {}>>`]);
    }
    else if (typeof script?.src === 'object') {
        exps.push([`{} as typeof import('${(0, src_1.resolveSrcPath)(script.src.text)}').default`]);
    }
    else {
        exps.push([`{} as import('${vueCompilerOptions.lib}').ComponentPublicInstance`]);
    }
    if (styleCodegen?.generatedTypes.has(names.StyleModules)) {
        exps.push([`{} as ${names.StyleModules}`]);
    }
    if (scriptSetupRanges?.defineEmits) {
        const { defineEmits } = scriptSetupRanges;
        emitTypes.push(`typeof ${defineEmits.name ?? names.emit}`);
    }
    if (scriptSetupRanges?.defineModel.length) {
        emitTypes.push(`typeof ${names.modelEmit}`);
    }
    if (emitTypes.length) {
        yield `type ${names.EmitProps} = __VLS_EmitsToProps<__VLS_NormalizeEmits<${emitTypes.join(` & `)}>>${utils_1.endOfLine}`;
        exps.push([`{} as { $emit: ${emitTypes.join(` & `)} }`]);
    }
    if (scriptSetupRanges?.defineProps) {
        propTypes.push(`typeof ${scriptSetupRanges.defineProps.name ?? names.props}`);
    }
    if (scriptSetupRanges?.defineModel.length) {
        propTypes.push(names.ModelProps);
    }
    if (emitTypes.length) {
        propTypes.push(names.EmitProps);
    }
    if (propTypes.length) {
        yield `type ${names.InternalProps} = ${propTypes.join(` & `)}${utils_1.endOfLine}`;
        exps.push([`{} as { $props: ${names.InternalProps} }`]);
        exps.push([`{} as ${names.InternalProps}`]);
    }
    if (ctx.generatedTypes.has(names.SetupExposed)) {
        exps.push([`{} as ${names.SetupExposed}`]);
    }
    yield `const ${names.ctx} = `;
    yield* (0, merge_1.generateSpreadMerge)(exps);
    yield utils_1.endOfLine;
}
function* generateTemplateComponents(options) {
    const types = [`typeof ${names.ctx}`];
    if (options.script && options.scriptRanges?.componentOptions?.components) {
        const { components } = options.scriptRanges.componentOptions;
        yield `const __VLS_componentsOption = `;
        yield* (0, utils_1.generateSfcBlockSection)(options.script, components.start, components.end, codeFeatures_1.codeFeatures.navigation);
        yield utils_1.endOfLine;
        types.push(`typeof __VLS_componentsOption`);
    }
    yield `type __VLS_LocalComponents = ${types.join(` & `)}${utils_1.endOfLine}`;
    yield `let ${names.components}!: __VLS_LocalComponents & __VLS_GlobalComponents${utils_1.endOfLine}`;
}
function* generateTemplateDirectives(options) {
    const types = [`typeof ${names.ctx}`];
    if (options.script && options.scriptRanges?.componentOptions?.directives) {
        const { directives } = options.scriptRanges.componentOptions;
        yield `const __VLS_directivesOption = `;
        yield* (0, utils_1.generateSfcBlockSection)(options.script, directives.start, directives.end, codeFeatures_1.codeFeatures.navigation);
        yield utils_1.endOfLine;
        types.push(`__VLS_ResolveDirectives<typeof __VLS_directivesOption>`);
    }
    yield `type __VLS_LocalDirectives = ${types.join(` & `)}${utils_1.endOfLine}`;
    yield `let ${names.directives}!: __VLS_LocalDirectives & __VLS_GlobalDirectives${utils_1.endOfLine}`;
}
function* generateSetupExposed({ setupExposed }, ctx) {
    if (!setupExposed.size) {
        return;
    }
    ctx.generatedTypes.add(names.SetupExposed);
    yield `type ${names.SetupExposed} = __VLS_ProxyRefs<{${utils_1.newLine}`;
    for (const bindingName of setupExposed) {
        const token = Symbol(bindingName.length);
        yield ['', undefined, 0, { __linkedToken: token }];
        yield `${bindingName}: typeof `;
        yield ['', undefined, 0, { __linkedToken: token }];
        yield bindingName;
        yield utils_1.endOfLine;
    }
    yield `}>${utils_1.endOfLine}`;
}
//# sourceMappingURL=template.js.map