
import type { DefineComponent, SlotsType } from 'vue'
type IslandComponent<T> = DefineComponent<{}, {refresh: () => Promise<void>}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, SlotsType<{ fallback: { error: unknown } }>> & T

type HydrationStrategies = {
  hydrateOnVisible?: IntersectionObserverInit | true
  hydrateOnIdle?: number | true
  hydrateOnInteraction?: keyof HTMLElementEventMap | Array<keyof HTMLElementEventMap> | true
  hydrateOnMediaQuery?: string
  hydrateAfter?: number
  hydrateWhen?: boolean
  hydrateNever?: true
}
type LazyComponent<T> = DefineComponent<HydrationStrategies, {}, {}, {}, {}, {}, {}, { hydrated: () => void }> & T

interface _GlobalComponents {
  'AuthHeader': typeof import("../../../../../app/components/AuthHeader.vue").default
  'Footer': typeof import("../../../../../app/components/Footer.vue").default
  'Header': typeof import("../../../../../app/components/Header.vue").default
  'Toaster': typeof import("../../../../../app/components/Toaster.vue").default
  'CommonButton': typeof import("../../../../../app/components/common/Button.vue").default
  'CommonSearchInput': typeof import("../../../../../app/components/common/SearchInput.vue").default
  'CourseBrowser': typeof import("../../../../../app/components/course/CourseBrowser.vue").default
  'CourseCard': typeof import("../../../../../app/components/course/CourseCard.vue").default
  'CourseSection': typeof import("../../../../../app/components/course/CourseSection.vue").default
  'SkeletonCourseCardSkeleton': typeof import("../../../../../app/components/skeleton/CourseCardSkeleton.vue").default
  'SkeletonCourseDetailsSkeleton': typeof import("../../../../../app/components/skeleton/CourseDetailsSkeleton.vue").default
  'NuxtWelcome': typeof import("../../../../nuxt/dist/app/components/welcome.vue").default
  'NuxtLayout': typeof import("../../../../nuxt/dist/app/components/nuxt-layout").default
  'NuxtErrorBoundary': typeof import("../../../../nuxt/dist/app/components/nuxt-error-boundary.vue").default
  'ClientOnly': typeof import("../../../../nuxt/dist/app/components/client-only").default
  'DevOnly': typeof import("../../../../nuxt/dist/app/components/dev-only").default
  'ServerPlaceholder': typeof import("../../../../nuxt/dist/app/components/server-placeholder").default
  'NuxtLink': typeof import("../../../../nuxt/dist/app/components/nuxt-link").default
  'NuxtLoadingIndicator': typeof import("../../../../nuxt/dist/app/components/nuxt-loading-indicator").default
  'NuxtTime': typeof import("../../../../nuxt/dist/app/components/nuxt-time.vue").default
  'NuxtRouteAnnouncer': typeof import("../../../../nuxt/dist/app/components/nuxt-route-announcer").default
  'NuxtImg': typeof import("../../../../nuxt/dist/app/components/nuxt-stubs").NuxtImg
  'NuxtPicture': typeof import("../../../../nuxt/dist/app/components/nuxt-stubs").NuxtPicture
  'NuxtPage': typeof import("../../../../nuxt/dist/pages/runtime/page").default
  'NoScript': typeof import("../../../../nuxt/dist/head/runtime/components").NoScript
  'Link': typeof import("../../../../nuxt/dist/head/runtime/components").Link
  'Base': typeof import("../../../../nuxt/dist/head/runtime/components").Base
  'Title': typeof import("../../../../nuxt/dist/head/runtime/components").Title
  'Meta': typeof import("../../../../nuxt/dist/head/runtime/components").Meta
  'Style': typeof import("../../../../nuxt/dist/head/runtime/components").Style
  'Head': typeof import("../../../../nuxt/dist/head/runtime/components").Head
  'Html': typeof import("../../../../nuxt/dist/head/runtime/components").Html
  'Body': typeof import("../../../../nuxt/dist/head/runtime/components").Body
  'NuxtIsland': typeof import("../../../../nuxt/dist/app/components/nuxt-island").default
  'LazyAuthHeader': LazyComponent<typeof import("../../../../../app/components/AuthHeader.vue").default>
  'LazyFooter': LazyComponent<typeof import("../../../../../app/components/Footer.vue").default>
  'LazyHeader': LazyComponent<typeof import("../../../../../app/components/Header.vue").default>
  'LazyToaster': LazyComponent<typeof import("../../../../../app/components/Toaster.vue").default>
  'LazyCommonButton': LazyComponent<typeof import("../../../../../app/components/common/Button.vue").default>
  'LazyCommonSearchInput': LazyComponent<typeof import("../../../../../app/components/common/SearchInput.vue").default>
  'LazyCourseBrowser': LazyComponent<typeof import("../../../../../app/components/course/CourseBrowser.vue").default>
  'LazyCourseCard': LazyComponent<typeof import("../../../../../app/components/course/CourseCard.vue").default>
  'LazyCourseSection': LazyComponent<typeof import("../../../../../app/components/course/CourseSection.vue").default>
  'LazySkeletonCourseCardSkeleton': LazyComponent<typeof import("../../../../../app/components/skeleton/CourseCardSkeleton.vue").default>
  'LazySkeletonCourseDetailsSkeleton': LazyComponent<typeof import("../../../../../app/components/skeleton/CourseDetailsSkeleton.vue").default>
  'LazyNuxtWelcome': LazyComponent<typeof import("../../../../nuxt/dist/app/components/welcome.vue").default>
  'LazyNuxtLayout': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-layout").default>
  'LazyNuxtErrorBoundary': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-error-boundary.vue").default>
  'LazyClientOnly': LazyComponent<typeof import("../../../../nuxt/dist/app/components/client-only").default>
  'LazyDevOnly': LazyComponent<typeof import("../../../../nuxt/dist/app/components/dev-only").default>
  'LazyServerPlaceholder': LazyComponent<typeof import("../../../../nuxt/dist/app/components/server-placeholder").default>
  'LazyNuxtLink': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-link").default>
  'LazyNuxtLoadingIndicator': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-loading-indicator").default>
  'LazyNuxtTime': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-time.vue").default>
  'LazyNuxtRouteAnnouncer': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-route-announcer").default>
  'LazyNuxtImg': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-stubs").NuxtImg>
  'LazyNuxtPicture': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-stubs").NuxtPicture>
  'LazyNuxtPage': LazyComponent<typeof import("../../../../nuxt/dist/pages/runtime/page").default>
  'LazyNoScript': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").NoScript>
  'LazyLink': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Link>
  'LazyBase': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Base>
  'LazyTitle': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Title>
  'LazyMeta': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Meta>
  'LazyStyle': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Style>
  'LazyHead': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Head>
  'LazyHtml': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Html>
  'LazyBody': LazyComponent<typeof import("../../../../nuxt/dist/head/runtime/components").Body>
  'LazyNuxtIsland': LazyComponent<typeof import("../../../../nuxt/dist/app/components/nuxt-island").default>
}

declare module 'vue' {
  export interface GlobalComponents extends _GlobalComponents { }
}

export {}
