
import type { DefineComponent, SlotsType } from 'vue'
type IslandComponent<T> = DefineComponent<{}, {refresh: () => Promise<void>}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, SlotsType<{ fallback: { error: unknown } }>> & T

type HydrationStrategies = {
  hydrateOnVisible?: IntersectionObserverInit | true
  hydrateOnIdle?: number | true
  hydrateOnInteraction?: keyof HTMLElementEventMap | Array<keyof HTMLElementEventMap> | true
  hydrateOnMediaQuery?: string
  hydrateAfter?: number
  hydrateWhen?: boolean
  hydrateNever?: true
}
type LazyComponent<T> = DefineComponent<HydrationStrategies, {}, {}, {}, {}, {}, {}, { hydrated: () => void }> & T


export const AuthHeader: typeof import("../../../../app/components/AuthHeader.vue").default
export const Footer: typeof import("../../../../app/components/Footer.vue").default
export const Header: typeof import("../../../../app/components/Header.vue").default
export const Toaster: typeof import("../../../../app/components/Toaster.vue").default
export const CommonButton: typeof import("../../../../app/components/common/Button.vue").default
export const CommonSearchInput: typeof import("../../../../app/components/common/SearchInput.vue").default
export const CourseBrowser: typeof import("../../../../app/components/course/CourseBrowser.vue").default
export const CourseCard: typeof import("../../../../app/components/course/CourseCard.vue").default
export const CourseSection: typeof import("../../../../app/components/course/CourseSection.vue").default
export const SkeletonCourseCardSkeleton: typeof import("../../../../app/components/skeleton/CourseCardSkeleton.vue").default
export const SkeletonCourseDetailsSkeleton: typeof import("../../../../app/components/skeleton/CourseDetailsSkeleton.vue").default
export const NuxtWelcome: typeof import("../../../nuxt/dist/app/components/welcome.vue").default
export const NuxtLayout: typeof import("../../../nuxt/dist/app/components/nuxt-layout").default
export const NuxtErrorBoundary: typeof import("../../../nuxt/dist/app/components/nuxt-error-boundary.vue").default
export const ClientOnly: typeof import("../../../nuxt/dist/app/components/client-only").default
export const DevOnly: typeof import("../../../nuxt/dist/app/components/dev-only").default
export const ServerPlaceholder: typeof import("../../../nuxt/dist/app/components/server-placeholder").default
export const NuxtLink: typeof import("../../../nuxt/dist/app/components/nuxt-link").default
export const NuxtLoadingIndicator: typeof import("../../../nuxt/dist/app/components/nuxt-loading-indicator").default
export const NuxtTime: typeof import("../../../nuxt/dist/app/components/nuxt-time.vue").default
export const NuxtRouteAnnouncer: typeof import("../../../nuxt/dist/app/components/nuxt-route-announcer").default
export const NuxtImg: typeof import("../../../nuxt/dist/app/components/nuxt-stubs").NuxtImg
export const NuxtPicture: typeof import("../../../nuxt/dist/app/components/nuxt-stubs").NuxtPicture
export const NuxtPage: typeof import("../../../nuxt/dist/pages/runtime/page").default
export const NoScript: typeof import("../../../nuxt/dist/head/runtime/components").NoScript
export const Link: typeof import("../../../nuxt/dist/head/runtime/components").Link
export const Base: typeof import("../../../nuxt/dist/head/runtime/components").Base
export const Title: typeof import("../../../nuxt/dist/head/runtime/components").Title
export const Meta: typeof import("../../../nuxt/dist/head/runtime/components").Meta
export const Style: typeof import("../../../nuxt/dist/head/runtime/components").Style
export const Head: typeof import("../../../nuxt/dist/head/runtime/components").Head
export const Html: typeof import("../../../nuxt/dist/head/runtime/components").Html
export const Body: typeof import("../../../nuxt/dist/head/runtime/components").Body
export const NuxtIsland: typeof import("../../../nuxt/dist/app/components/nuxt-island").default
export const LazyAuthHeader: LazyComponent<typeof import("../../../../app/components/AuthHeader.vue").default>
export const LazyFooter: LazyComponent<typeof import("../../../../app/components/Footer.vue").default>
export const LazyHeader: LazyComponent<typeof import("../../../../app/components/Header.vue").default>
export const LazyToaster: LazyComponent<typeof import("../../../../app/components/Toaster.vue").default>
export const LazyCommonButton: LazyComponent<typeof import("../../../../app/components/common/Button.vue").default>
export const LazyCommonSearchInput: LazyComponent<typeof import("../../../../app/components/common/SearchInput.vue").default>
export const LazyCourseBrowser: LazyComponent<typeof import("../../../../app/components/course/CourseBrowser.vue").default>
export const LazyCourseCard: LazyComponent<typeof import("../../../../app/components/course/CourseCard.vue").default>
export const LazyCourseSection: LazyComponent<typeof import("../../../../app/components/course/CourseSection.vue").default>
export const LazySkeletonCourseCardSkeleton: LazyComponent<typeof import("../../../../app/components/skeleton/CourseCardSkeleton.vue").default>
export const LazySkeletonCourseDetailsSkeleton: LazyComponent<typeof import("../../../../app/components/skeleton/CourseDetailsSkeleton.vue").default>
export const LazyNuxtWelcome: LazyComponent<typeof import("../../../nuxt/dist/app/components/welcome.vue").default>
export const LazyNuxtLayout: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-layout").default>
export const LazyNuxtErrorBoundary: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-error-boundary.vue").default>
export const LazyClientOnly: LazyComponent<typeof import("../../../nuxt/dist/app/components/client-only").default>
export const LazyDevOnly: LazyComponent<typeof import("../../../nuxt/dist/app/components/dev-only").default>
export const LazyServerPlaceholder: LazyComponent<typeof import("../../../nuxt/dist/app/components/server-placeholder").default>
export const LazyNuxtLink: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-link").default>
export const LazyNuxtLoadingIndicator: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-loading-indicator").default>
export const LazyNuxtTime: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-time.vue").default>
export const LazyNuxtRouteAnnouncer: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-route-announcer").default>
export const LazyNuxtImg: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-stubs").NuxtImg>
export const LazyNuxtPicture: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-stubs").NuxtPicture>
export const LazyNuxtPage: LazyComponent<typeof import("../../../nuxt/dist/pages/runtime/page").default>
export const LazyNoScript: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").NoScript>
export const LazyLink: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Link>
export const LazyBase: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Base>
export const LazyTitle: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Title>
export const LazyMeta: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Meta>
export const LazyStyle: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Style>
export const LazyHead: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Head>
export const LazyHtml: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Html>
export const LazyBody: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components").Body>
export const LazyNuxtIsland: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-island").default>

export const componentNames: string[]
