// Common API Response Types

export interface ApiResponse<T = any> {
  success: boolean;
  message?: string;
  data: T;
}

export interface PaginatedResponse<T = any> {
  success: boolean;
  message?: string;
  data: {
    data: T[];
    current_page: number;
    total_pages: number;
    per_page: number;
    total: number;
  };
}
