import { defineStore } from 'pinia'
import { ref } from 'vue'

export const useToasterStore = defineStore('toaster', () => {
  const toasts = ref([] as { id: number; message: string; type: 'success' | 'error' | 'info' }[])

  const addToast = (message: string, type: 'success' | 'error' | 'info' = 'info') => {
    const id = Date.now()
    toasts.value.push({ id, message, type })
    setTimeout(() => removeToast(id), 2000)
  }

  const removeToast = (id: number) => {
    toasts.value = toasts.value.filter(toast => toast.id !== id)
  }

  return {
    toasts,
    addToast,
    removeToast
  }
})