import { defineStore } from 'pinia'

export const useSettingsStore = defineStore('settings', () => {
  const { public: { apiBase, backendBase } } = useRuntimeConfig()

  const platformLogo = ref<string | null>(null)
  const isLoading = ref(false)
  const initialized = ref(false)

  const fetchPlatformLogo = async () => {
    if (initialized.value) return

    isLoading.value = true
    try {
      const data = await $fetch<any>(
        `${apiBase}/settings`,
        {
          method: 'GET',
          headers: {
            'Content-Type': 'application/json',
            Accept: 'application/json'
          }
        }
      )

      const logoPath = data?.settings?.general?.platform_logo

      if (logoPath) {
        // If the API returns a full URL, use it directly, otherwise prefix with backendBase
        platformLogo.value = /^https?:\/\//.test(logoPath) ? logoPath : `${backendBase}/${logoPath}`
      }
      initialized.value = true
      return { success: true }
    } catch (err) {
      console.error('Failed to fetch platform logo:', err)
      initialized.value = true
      return { success: false }
    } finally {
      isLoading.value = false
    }
  }

  return {
    platformLogo,
    isLoading,
    initialized,
    fetchPlatformLogo
  }
})
