import { defineStore } from "pinia";

export const useCoursesStore = defineStore("courses", () => {
  const courses = ref([]);
  const loading = ref(false);
  const error = ref(null);
  const loaded = ref(false); // ✅ prevent duplicate requests

  const courseDetail = ref(null);
  const courseDetailLoading = ref(false);
  const courseDetailError = ref(null);

  const fetchCourses = async () => {
    if (loaded.value) return; // ⛔ Already fetched — prevent refetch

    loading.value = true;
    error.value = null;

    try {
      const res = await $fetch<{data: any[]}>("/student/courses", {
        baseURL: useRuntimeConfig().public.apiBase,
      });

      courses.value = res?.data || [];
      loaded.value = true; // mark as loaded

    } catch (err: any) {
      error.value = err.message || "Failed to fetch courses";
    }

    loading.value = false;
  };

  const fetchCourseById = async (id: string) => {
    courseDetailLoading.value = true;
    courseDetailError.value = null;

    try {
      const res = await $fetch<{data: any}>(`/student/courses/${id}`, {
        baseURL: useRuntimeConfig().public.apiBase,
      });

      courseDetail.value = res?.data || null;

    } catch (err: any) {
      courseDetailError.value = err.message || "Failed to fetch course details";
    }

    courseDetailLoading.value = false;
  };





    const categoryData = ref<any>(null);
    const categoryCourses = ref<any[]>([]);
    const categoryPagination = ref<any>(null);

    const categoryLoading = ref(false);
    const categoryError = ref<string | null>(null);

    const fetchCoursesByCategory = async (categoryId: string) => {
      categoryLoading.value = true;
      categoryError.value = null;

      try {
        const config = useRuntimeConfig();

        const res = await $fetch<{data: any}>(`/student/courses/category/${categoryId}`, {
          baseURL: config.public.apiBase,
        });

        const data = res?.data;

        categoryData.value = data?.category || null;
        categoryCourses.value = data?.courses || [];
        categoryPagination.value = data?.pagination || null;

      } catch (err: any) {
        categoryError.value =
          err?.message || "Failed to load category courses";
      }

      categoryLoading.value = false;
    };




  return {
    courses,
    fetchCourses,
    loading,
    error,
    courseDetail,
    fetchCourseById,
    courseDetailLoading,
    courseDetailError,
    categoryData,
    categoryCourses,
    categoryPagination,
    categoryLoading,
    categoryError,
    fetchCoursesByCategory,
  };
});
