// middleware/auth.ts
export default defineNuxtRouteMiddleware(async (to, from) => {
  const authStore = useAuthStore()

  // Step 1: Check if token exists
  if (!authStore.isAuthenticated) {
    return navigateTo({
      path: '/login',
      query: { redirect: to.fullPath }
    })
  }

  // Step 2: Check if user info exists
  if (!authStore.user) {
    try {
      await authStore.fetchUser()
    } catch (err: any) {
      // Step 3: If fetch failed due to token expiry, try refresh
      if (err?.response?.status === 401 || err?.message.includes('token')) {
        try {
          await authStore.refreshToken()   // auto refresh
          await authStore.fetchUser()      // retry fetching user
        } catch (refreshErr) {
          // Refresh failed → logout
          await authStore.logout()
          return navigateTo({
            path: '/login',
            query: { redirect: to.fullPath }
          })
        }
      } else {
        // Other errors
        console.error('Auth fetchUser error:', err)
        return navigateTo({
          path: '/login',
          query: { redirect: to.fullPath }
        })
      }
    }
  }
})
