export default defineNuxtRouteMiddleware(async (to, from) => {
  const authStore = useAuthStore()

  // যদি token cookie থেকে read করা যায়, server/client দুইয়ে fetchUser call করা যায়
  if (authStore.token && !authStore.user) {
    try {
      await authStore.fetchUser()
    } catch (error) {
      console.error('Auth check failed:', error)
      // logout clears token & user
      await authStore.logout()
    }
  }
})
