import { useToasterStore } from '~/stores/toaster'

export const useToaster = () => {
  const toasterStore = useToasterStore()

  const addToast = (message: string, type: 'success' | 'error' | 'info' = 'info') => {
    toasterStore.addToast(message, type)
  }

  const removeToast = (id: number) => {
    toasterStore.removeToast(id)
  }

  return {
    addToast,
    removeToast,
    toasts: computed(() => toasterStore.toasts)
  }
}