# Implementation Plan: Mega Menu & Dynamic Navigation

This plan outlines the steps to implement the requested features for the LMS application.

## 1. Desktop Header: Mega Menu ("Explore" Button)

**Goal:** Add an "Explore" button next to the logo that reveals a mega menu on hover, displaying dynamic categories.

**Steps:**
1.  **Modify `app/components/Header.vue`:**
    *   Import `useSearchStore` to fetch and access categories.
    *   Add a new "Explore" button in the desktop header section (next to the logo).
    *   Create a "Mega Menu" container that shows/hides based on hover state of the "Explore" button.
    *   **Mega Menu Structure:**
        *   Left column: "Explore categories" (Dynamic list from `searchStore.categories`).
        *   Right column: Sub-categories or popular courses (optional, or just a static list/placeholder as per the image if no sub-category data exists). *Note: The provided image shows "Explore roles", "Explore categories", "Earn a Professional Certificate", etc. I will implement a structure similar to the image, with "Explore categories" being dynamic.*
    *   Fetch categories on mount (if not already loaded).

## 2. Mobile Header: Dynamic Navigation & Search

**Goal:** Ensure the mobile navigation is "staticy" (sticky/fixed) and the menu lists categories dynamically. Also ensure the search input is dynamic.

**Steps:**
1.  **Modify `app/components/Header.vue` (Mobile Section):**
    *   **Sticky Header:** The header already has `sticky top-0`, which should satisfy "staticy nav". I will verify this behavior.
    *   **Dynamic Categories in Sidebar:**
        *   In the `isSidebarOpen` section, replace the static `menuItems` (or append to them) with a dynamic list of categories from `searchStore.categories`.
        *   Each category link will point to `/courses/category/[id]`.
    *   **Dynamic Search:**
        *   The mobile search currently opens a sidebar with `CommonSearchInput`.
        *   I will ensure `CommonSearchInput` is working correctly (it currently redirects to `/courses?q=...`).
        *   I will add a "Browse Categories" section inside the search sidebar as well, or ensure the main sidebar handles this well.

## 3. Data Fetching

**Goal:** Ensure categories are available for the header components.

**Steps:**
1.  **Store Integration:**
    *   Use `app/stores/search.ts` in `Header.vue`.
    *   Call `searchStore.fetchCategories()` in `onMounted` of `Header.vue` to ensure data is available.

## 4. Styling

**Goal:** Match the look and feel of the provided Coursera image.

**Steps:**
1.  Use Tailwind CSS to style the Mega Menu (absolute positioning, z-index, grid layout, hover effects).
2.  Style the "Explore" button (blue text, chevron down icon).
3.  Ensure the mobile menu items are styled consistently.

---

**Status:** Completed.
